/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/FragmentationMsr.h>

namespace imagedev
{
/// Computes an index of relative convexity or concavity of the surface of objects from a binary image.
class IMAGEDEV_CPP_API FragmentationIndex final : public GenericAlgorithm
{
public:

    // Command constructor.
    FragmentationIndex();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the kernelRadius parameter.
    /// The number of iterations of the dilation (that is, the half side size of the cubic structuring element in voxels). A cube structuring element always has an odd side length (3x3x3, 5x5x5, etc.) which is defined by twice the kernel radius + 1.
    int32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The number of iterations of the dilation (that is, the half side size of the cubic structuring element in voxels). A cube structuring element always has an odd side length (3x3x3, 5x5x5, etc.) which is defined by twice the kernel radius + 1.
    void setKernelRadius( const int32_t& kernelRadius );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    FragmentationMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes an index of relative convexity or concavity of the surface of objects from a binary image.
/// @param inputBinaryImage The binary input image.
/// @param kernelRadius The number of iterations of the dilation (that is, the half side size of the cubic structuring element in voxels). A cube structuring element always has an odd side length (3x3x3, 5x5x5, etc.) which is defined by twice the kernel radius + 1.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
FragmentationMsr::Ptr
fragmentationIndex( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                    int32_t kernelRadius,
                    FragmentationMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
