/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Fills holes in particles of a three-dimensional grayscale image.
class IMAGEDEV_CPP_API GrayscaleFillHoles3d final : public GenericAlgorithm
{
public:
    /// The 3D neighborhood configuration.
    enum Neighborhood
    {
    /// The structuring element is composed of voxels with a common face with the voxel of interest.
        CONNECTIVITY_6 = 0,
    /// The structuring element is composed of voxels with at least one common edge.
        CONNECTIVITY_18,
    /// The structuring element is a full cube.
        CONNECTIVITY_26
    };

    // Command constructor.
    GrayscaleFillHoles3d();


    /// Gets the inputImage parameter.
    /// The grayscale input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The grayscale input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the thresholdFillingValue parameter.
    /// The value filling the marker image inside (the gray level under which valleys are filled). The common usage is to set it at the image maximum intensity.
    double thresholdFillingValue() const;
    /// Sets the thresholdFillingValue parameter.
    /// The value filling the marker image inside (the gray level under which valleys are filled). The common usage is to set it at the image maximum intensity.
    void setThresholdFillingValue( const double& thresholdFillingValue );

    /// Gets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    GrayscaleFillHoles3d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    void setNeighborhood( const GrayscaleFillHoles3d::Neighborhood& neighborhood );

    /// Gets the outputImage parameter.
    /// The grayscale output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The grayscale output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Fills holes in particles of a three-dimensional grayscale image.
/// @param inputImage The grayscale input image.
/// @param thresholdFillingValue The value filling the marker image inside (the gray level under which valleys are filled). The common usage is to set it at the image maximum intensity.
/// @param neighborhood The 3D neighborhood configuration.
/// @param outputImage The grayscale output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
grayscaleFillHoles3d( std::shared_ptr< iolink::ImageView > inputImage,
                      double thresholdFillingValue,
                      GrayscaleFillHoles3d::Neighborhood neighborhood,
                      std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
