/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Assigns a same label to objects that are closed to each other.
class IMAGEDEV_CPP_API GroupCloseLabelsl2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    GroupCloseLabelsl2d();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the maxDistance parameter.
    /// The maximum distance beteween two objects for grouping them.
    double maxDistance() const;
    /// Sets the maxDistance parameter.
    /// The maximum distance beteween two objects for grouping them.
    void setMaxDistance( const double& maxDistance );

    /// Gets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Assigns a same label to objects that are closed to each other.
/// @param inputObjectImage The input binary or label image.
/// @param maxDistance The maximum distance beteween two objects for grouping them.
/// @param outputLabelImage The output label image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputLabelImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
groupCloseLabelsl2d( std::shared_ptr< iolink::ImageView > inputObjectImage,
                     double maxDistance,
                     std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
