/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Enhances the contrast of an image by performing an histogram equalization.
class IMAGEDEV_CPP_API HistogramEqualization final : public GenericAlgorithm
{
public:
    /// The way to define the input intensity range.
    enum RangeMode
    {
    /// The input intensity range is between the minimum and the maximum of the image intensities.
        MIN_MAX = 0,
    /// The input intensity range is between user-defined bounds [a,b].
        OTHER
    };

    // Command constructor.
    HistogramEqualization();


    /// Gets the inputImage parameter.
    /// The input image to enhance.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image to enhance.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the rangeMode parameter.
    /// The way to define the input intensity range.
    HistogramEqualization::RangeMode rangeMode() const;
    /// Sets the rangeMode parameter.
    /// The way to define the input intensity range.
    void setRangeMode( const HistogramEqualization::RangeMode& rangeMode );

    /// Gets the intensityInputRange parameter.
    /// The input intensity range [a, b] to use when the range mode is set to OTHER. This parameter is ignored with the MIN_MAX range mode.
    iolink::Vector2i32 intensityInputRange() const;
    /// Sets the intensityInputRange parameter.
    /// The input intensity range [a, b] to use when the range mode is set to OTHER. This parameter is ignored with the MIN_MAX range mode.
    void setIntensityInputRange( const iolink::Vector2i32& intensityInputRange );

    /// Gets the intensityOutputRange parameter.
    /// The output intensity range.
    iolink::Vector2i32 intensityOutputRange() const;
    /// Sets the intensityOutputRange parameter.
    /// The output intensity range.
    void setIntensityOutputRange( const iolink::Vector2i32& intensityOutputRange );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Enhances the contrast of an image by performing an histogram equalization.
/// @param inputImage The input image to enhance.
/// @param rangeMode The way to define the input intensity range.
/// @param intensityInputRange The input intensity range [a, b] to use when the range mode is set to OTHER. This parameter is ignored with the MIN_MAX range mode.
/// @param intensityOutputRange The output intensity range.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
histogramEqualization( std::shared_ptr< iolink::ImageView > inputImage,
                       HistogramEqualization::RangeMode rangeMode,
                       const iolink::Vector2i32& intensityInputRange,
                       const iolink::Vector2i32& intensityOutputRange,
                       std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
