/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes a new image by applying a user-defined formula on one, two, or three input images.
class IMAGEDEV_CPP_API ImageFormula final : public GenericAlgorithm
{
public:
    /// The output image data type.
    enum OutputType
    {
    /// The output image data type is 1 byte depth. Its possible intensities are unsigned integer from 0 to 255.
        UNSIGNED_INTEGER_8_BIT = 0,
    /// The output image data type is 1 byte depth. Its possible intensities are signed integer from -128 to 127.
        SIGNED_INTEGER_8_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are signed integer from -32,768 to 32,767.
        SIGNED_INTEGER_16_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are unsigned integer from 0 to 65,535.
        UNSIGNED_INTEGER_16_BIT,
    /// The output image data type is 2 bytes depth and interpretation is label. Its possible intensities are unsigned integer from 0 to 65,535.
        LABEL_16_BIT,
    /// The output image data type is 2 bytes depth and interpretation is binary. Its possible intensities are 0 and 1.
        BINARY,
    /// The output image data type is 4 bytes depth. Its possible intensities are signed integer from -2,147,483,648 to  2,147,483,647.
        SIGNED_INTEGER_32_BIT,
    /// The output image data type is 4 bytes depth. Its possible intensities are unsigned floating-point from -3.4E38 to 3.4E38.
        FLOAT_32_BIT
    };

    // Command constructor.
    ImageFormula();


    /// Gets the inputImage1 parameter.
    /// The first input image.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image (optional).
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image (optional).
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the inputImage3 parameter.
    /// The third input image (optional).
    std::shared_ptr< iolink::ImageView > inputImage3() const;
    /// Sets the inputImage3 parameter.
    /// The third input image (optional).
    void setInputImage3( std::shared_ptr< iolink::ImageView > inputImage3 );

    /// Gets the formula parameter.
    /// The formula to apply on the input image(s).
    std::string formula() const;
    /// Sets the formula parameter.
    /// The formula to apply on the input image(s).
    void setFormula( const std::string& formula );

    /// Gets the outputType parameter.
    /// The output image data type.
    ImageFormula::OutputType outputType() const;
    /// Sets the outputType parameter.
    /// The output image data type.
    void setOutputType( const ImageFormula::OutputType& outputType );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is user-defined.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is user-defined.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Computes a new image by applying a user-defined formula on one, two, or three input images.
/// @param inputImage1 The first input image.
/// @param inputImage2 The second input image (optional).
/// @param inputImage3 The third input image (optional).
/// @param formula The formula to apply on the input image(s).
/// @param outputType The output image data type.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is user-defined.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
imageFormula( std::shared_ptr< iolink::ImageView > inputImage1,
              std::shared_ptr< iolink::ImageView > inputImage2,
              std::shared_ptr< iolink::ImageView > inputImage3,
              const std::string& formula,
              ImageFormula::OutputType outputType,
              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
