/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/IntensityBinHistogramMsr.h>

namespace imagedev
{
/// Computes the histogram of a gray level image with a user-defined bin size.
class IMAGEDEV_CPP_API IntensityBinHistogram final : public GenericAlgorithm
{
public:

    // Command constructor.
    IntensityBinHistogram();


    /// Gets the inputImage parameter.
    /// The input gray scale image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input gray scale image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the intensityInputRange parameter.
    /// The minimal and maximal value of the histogram.
    iolink::Vector2d intensityInputRange() const;
    /// Sets the intensityInputRange parameter.
    /// The minimal and maximal value of the histogram.
    void setIntensityInputRange( const iolink::Vector2d& intensityInputRange );

    /// Gets the binSize parameter.
    /// The size of a class of the histogram. Note that the histogram is divided into equal intervals.
    double binSize() const;
    /// Sets the binSize parameter.
    /// The size of a class of the histogram. Note that the histogram is divided into equal intervals.
    void setBinSize( const double& binSize );

    /// Gets the outputMeasurement parameter.
    /// The output histogram.
    IntensityBinHistogramMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes the histogram of a gray level image with a user-defined bin size.
/// @param inputImage The input gray scale image.
/// @param intensityInputRange The minimal and maximal value of the histogram.
/// @param binSize The size of a class of the histogram. Note that the histogram is divided into equal intervals.
/// @param outputMeasurement The output histogram.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
IntensityBinHistogramMsr::Ptr
intensityBinHistogram( std::shared_ptr< iolink::ImageView > inputImage,
                       const iolink::Vector2d& intensityInputRange,
                       double binSize,
                       IntensityBinHistogramMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
