/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/IntensityExtremaMsr.h>

namespace imagedev
{
/// Computes basic minimum and maximum intensities of an image.
class IMAGEDEV_CPP_API IntensityExtrema final : public GenericAlgorithm
{
public:
    /// The dimension management in case of 3D volume, multi channel, and time series input.
    enum SplitResult
    {
    /// A single result is given for all the input dimensions.
        NONE = 0,
    /// A result is given for each XY slice of a 3D volume.
        BY_PLANE = 1,
    /// A result is given for each channel of a multi-channel image.
        BY_CHANEL = 2,
    /// A result is given for each step of a time series.
        BY_TIME_STEP = 4
    };

    // Command constructor.
    IntensityExtrema();


    /// Gets the inputImage parameter.
    /// The input image. It can be grayscale, color, multi-channel, or time series.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image. It can be grayscale, color, multi-channel, or time series.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the splitResult parameter.
    /// The dimension management in case of 3D volume, multi channel, and time series input.
    int32_t splitResult() const;
    /// Sets the splitResult parameter.
    /// The dimension management in case of 3D volume, multi channel, and time series input.
    void setSplitResult( const int32_t& splitResult );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    IntensityExtremaMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes basic minimum and maximum intensities of an image.
/// @param inputImage The input image. It can be grayscale, color, multi-channel, or time series.
/// @param splitResult The dimension management in case of 3D volume, multi channel, and time series input.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
IntensityExtremaMsr::Ptr
intensityExtrema( std::shared_ptr< iolink::ImageView > inputImage,
                  int32_t splitResult,
                  IntensityExtremaMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
