/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/IntensityHistogramMsr.h>

namespace imagedev
{
/// Computes the histogram of a gray level image.
class IMAGEDEV_CPP_API IntensityHistogram final : public GenericAlgorithm
{
public:
    /// The way to determine the input intensity range within which the histogram is computed.
    enum RangeMode
    {
    /// This histogram is computed between the minimum and the maximum of the image.
        MIN_MAX = 0,
    /// This histogram is computed between user-defined bounds [a,b].
        OTHER
    };

    // Command constructor.
    IntensityHistogram();


    /// Gets the inputImage parameter.
    /// The input gray scale image. Float images are not supported
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input gray scale image. Float images are not supported
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the rangeMode parameter.
    /// The way to determine the input intensity range within which the histogram is computed.
    IntensityHistogram::RangeMode rangeMode() const;
    /// Sets the rangeMode parameter.
    /// The way to determine the input intensity range within which the histogram is computed.
    void setRangeMode( const IntensityHistogram::RangeMode& rangeMode );

    /// Gets the intensityInputRange parameter.
    /// The input intensity range [a,b] within which the histogram is computed. This parameter is ignored if the range mode is set to MIN_MAX.
    iolink::Vector2i32 intensityInputRange() const;
    /// Sets the intensityInputRange parameter.
    /// The input intensity range [a,b] within which the histogram is computed. This parameter is ignored if the range mode is set to MIN_MAX.
    void setIntensityInputRange( const iolink::Vector2i32& intensityInputRange );

    /// Gets the outputMeasurement parameter.
    /// The output histogram.
    IntensityHistogramMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes the histogram of a gray level image.
/// @param inputImage The input gray scale image. Float images are not supported
/// @param rangeMode The way to determine the input intensity range within which the histogram is computed.
/// @param intensityInputRange The input intensity range [a,b] within which the histogram is computed. This parameter is ignored if the range mode is set to MIN_MAX.
/// @param outputMeasurement The output histogram.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
IntensityHistogramMsr::Ptr
intensityHistogram( std::shared_ptr< iolink::ImageView > inputImage,
                    IntensityHistogram::RangeMode rangeMode,
                    const iolink::Vector2i32& intensityInputRange,
                    IntensityHistogramMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
