/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Merges two images, considered as even and odd frames, to produce an interlaced image.
class IMAGEDEV_CPP_API InterlaceFrames2d final : public GenericAlgorithm
{
public:
    /// The split mode for generating the output image.
    enum SplitMode
    {
    /// This mode considers both input images as having half the Y size of the output image. The whole information of both input images is preserved by this mode.
        HALF_IMAGE = 0,
    /// This mode considers both input images as having the same size as the output image by ignoring every second horizontal line. One row out of two from each input image is lost with this mode.
        FULL_IMAGE
    };

    // Command constructor.
    InterlaceFrames2d();


    /// Gets the inputEvenImage parameter.
    /// The input even field image.
    std::shared_ptr< iolink::ImageView > inputEvenImage() const;
    /// Sets the inputEvenImage parameter.
    /// The input even field image.
    void setInputEvenImage( std::shared_ptr< iolink::ImageView > inputEvenImage );

    /// Gets the inputOddImage parameter.
    /// The input odd field image. It must have same dimensions and type as the even field.
    std::shared_ptr< iolink::ImageView > inputOddImage() const;
    /// Sets the inputOddImage parameter.
    /// The input odd field image. It must have same dimensions and type as the even field.
    void setInputOddImage( std::shared_ptr< iolink::ImageView > inputOddImage );

    /// Gets the splitMode parameter.
    /// The split mode for generating the output image.
    InterlaceFrames2d::SplitMode splitMode() const;
    /// Sets the splitMode parameter.
    /// The split mode for generating the output image.
    void setSplitMode( const InterlaceFrames2d::SplitMode& splitMode );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Merges two images, considered as even and odd frames, to produce an interlaced image.
/// @param inputEvenImage The input even field image.
/// @param inputOddImage The input odd field image. It must have same dimensions and type as the even field.
/// @param splitMode The split mode for generating the output image.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
interlaceFrames2d( std::shared_ptr< iolink::ImageView > inputEvenImage,
                   std::shared_ptr< iolink::ImageView > inputOddImage,
                   InterlaceFrames2d::SplitMode splitMode,
                   std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
