/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Removes the objects connected to the borders of a segmented 2D image.
class IMAGEDEV_CPP_API KillBorder2d final : public GenericAlgorithm
{
public:
    /// The 2D neighborhood configuration.
    enum Neighborhood
    {
    /// Morphological reconstruction is performed with a 4-neighbor connectivity.
        CONNECTIVITY_4 = 0,
    /// Morphological reconstruction is performed with a 8-neighbor connectivity.
        CONNECTIVITY_8
    };

    // Command constructor.
    KillBorder2d();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the neighborhood parameter.
    /// The 2D neighborhood configuration.
    KillBorder2d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 2D neighborhood configuration.
    void setNeighborhood( const KillBorder2d::Neighborhood& neighborhood );

    /// Gets the outputObjectImage parameter.
    /// The output binary or label image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputObjectImage() const;
    /// Sets the outputObjectImage parameter.
    /// The output binary or label image. Its dimensions and type are forced to the same values as the input.
    void setOutputObjectImage( std::shared_ptr< iolink::ImageView > outputObjectImage );

    // Method to launch the command.
    void execute();

};

/// Removes the objects connected to the borders of a segmented 2D image.
/// @param inputObjectImage The input binary or label image.
/// @param neighborhood The 2D neighborhood configuration.
/// @param outputObjectImage The output binary or label image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputObjectImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
killBorder2d( std::shared_ptr< iolink::ImageView > inputObjectImage,
              KillBorder2d::Neighborhood neighborhood,
              std::shared_ptr< iolink::ImageView > outputObjectImage = nullptr );
} // namespace imagedev
