/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Removes the objects connected to the borders of a segmented image.
class IMAGEDEV_CPP_API KillBorder3d final : public GenericAlgorithm
{
public:
    /// The 3D neighborhood configuration.
    enum Neighborhood
    {
    /// The structuring element is composed of voxels with a common face with the voxel of interest.
        CONNECTIVITY_6 = 0,
    /// The structuring element is composed of voxels with at least one common edge.
        CONNECTIVITY_18,
    /// The structuring element is a full cube.
        CONNECTIVITY_26
    };

    // Command constructor.
    KillBorder3d();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    KillBorder3d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    void setNeighborhood( const KillBorder3d::Neighborhood& neighborhood );

    /// Gets the outputObjectImage parameter.
    /// The output binary or label image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputObjectImage() const;
    /// Sets the outputObjectImage parameter.
    /// The output binary or label image. Its dimensions and type are forced to the same values as the input.
    void setOutputObjectImage( std::shared_ptr< iolink::ImageView > outputObjectImage );

    // Method to launch the command.
    void execute();

};

/// Removes the objects connected to the borders of a segmented image.
/// @param inputObjectImage The input binary or label image.
/// @param neighborhood The 3D neighborhood configuration.
/// @param outputObjectImage The output binary or label image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputObjectImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
killBorder3d( std::shared_ptr< iolink::ImageView > inputObjectImage,
              KillBorder3d::Neighborhood neighborhood,
              std::shared_ptr< iolink::ImageView > outputObjectImage = nullptr );
} // namespace imagedev
