/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/AnalysisMeasurements/AnalysisMsr.h>

namespace imagedev
{
// Output structure of the labelFilteringAnalysis function.
struct LabelFilteringAnalysisOutput
{
    /// The output label image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputLabelImage;
    /// The output analysis.
    AnalysisMsr::Ptr outputAnalysis;
};

/// Computes measurements on objects and filters them from a label image.
class IMAGEDEV_CPP_API LabelFilteringAnalysis final : public GenericAlgorithm
{
public:

    // Command constructor.
    LabelFilteringAnalysis();


    /// Gets the inputLabelImage parameter.
    /// The label input image
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The label input image
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the inputIntensityImage parameter.
    /// The intensity input image. If it equals null, the label input image will be used as the intensity input image.
    std::shared_ptr< iolink::ImageView > inputIntensityImage() const;
    /// Sets the inputIntensityImage parameter.
    /// The intensity input image. If it equals null, the label input image will be used as the intensity input image.
    void setInputIntensityImage( std::shared_ptr< iolink::ImageView > inputIntensityImage );

    /// Gets the inputFilter parameter.
    /// The input filter formula.
    std::string inputFilter() const;
    /// Sets the inputFilter parameter.
    /// The input filter formula.
    void setInputFilter( const std::string& inputFilter );

    /// Gets the outputAnalysis parameter.
    /// The output analysis.
    AnalysisMsr::Ptr outputAnalysis() const;
    /// Sets the outputAnalysis parameter.
    /// The output analysis.
    void setOutputAnalysis( AnalysisMsr::Ptr outputAnalysis );

    /// Gets the outputLabelImage parameter.
    /// The output label image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image. Its dimensions and type are forced to the same values as the input.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Computes measurements on objects and filters them from a label image.
/// @param inputLabelImage The label input image
/// @param inputIntensityImage The intensity input image. If it equals null, the label input image will be used as the intensity input image.
/// @param inputFilter The input filter formula.
/// @param outputAnalysis The output analysis.
/// @param outputLabelImage The output label image. Its dimensions and type are forced to the same values as the input.
/// @return Returns a LabelFilteringAnalysisOutput structure containing the outputAnalysis and outputLabelImage output parameters.
IMAGEDEV_CPP_API 
LabelFilteringAnalysisOutput
labelFilteringAnalysis( std::shared_ptr< iolink::ImageView > inputLabelImage,
                        std::shared_ptr< iolink::ImageView > inputIntensityImage,
                        const std::string& inputFilter,
                        AnalysisMsr::Ptr outputAnalysis = nullptr,
                        std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
