/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Generates a binary image containing points having a minimum number of different neighbors in a label input image.
class IMAGEDEV_CPP_API LabelInterfaces final : public GenericAlgorithm
{
public:
    /// The way to look for interface points.
    enum OnlyBlackVoxels
    {
    /// Interface points are searched everywhere in the input image.
        NO = 0,
    /// Interface points are searched only in the image background (where intensity equals 0).
        YES
    };
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    enum Neighborhood
    {
    /// The structuring element is composed of voxels with a common face with the voxel of interest.
        CONNECTIVITY_6 = 0,
    /// The structuring element is composed of voxels with at least one common edge.
        CONNECTIVITY_18,
    /// The structuring element is a full cube.
        CONNECTIVITY_26
    };

    // Command constructor.
    LabelInterfaces();


    /// Gets the inputLabelImage parameter.
    /// The input label image.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The input label image.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the phaseNumber parameter.
    /// The minimum number of different neighbor labels to select a point.
    int32_t phaseNumber() const;
    /// Sets the phaseNumber parameter.
    /// The minimum number of different neighbor labels to select a point.
    void setPhaseNumber( const int32_t& phaseNumber );

    /// Gets the onlyBlackVoxels parameter.
    /// The way to look for interface points.
    LabelInterfaces::OnlyBlackVoxels onlyBlackVoxels() const;
    /// Sets the onlyBlackVoxels parameter.
    /// The way to look for interface points.
    void setOnlyBlackVoxels( const LabelInterfaces::OnlyBlackVoxels& onlyBlackVoxels );

    /// Gets the neighborhood parameter.
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    LabelInterfaces::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    void setNeighborhood( const LabelInterfaces::Neighborhood& neighborhood );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Generates a binary image containing points having a minimum number of different neighbors in a label input image.
/// @param inputLabelImage The input label image.
/// @param phaseNumber The minimum number of different neighbor labels to select a point.
/// @param onlyBlackVoxels The way to look for interface points.
/// @param neighborhood The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
labelInterfaces( std::shared_ptr< iolink::ImageView > inputLabelImage,
                 int32_t phaseNumber,
                 LabelInterfaces::OnlyBlackVoxels onlyBlackVoxels,
                 LabelInterfaces::Neighborhood neighborhood,
                 std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
