/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Approximates an image Laplacian by using morphological operations.
class IMAGEDEV_CPP_API MorphologicalLaplacian final : public GenericAlgorithm
{
public:
    /// The precision for computation for 3D morphological operations.
    enum Precision
    {
    /// The mophological operations are computed using the fast mode.
        FASTER = 0,
    /// The mophological operations are computed using the precise mode.
        PRECISE
    };

    // Command constructor.
    MorphologicalLaplacian();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the precision parameter.
    /// The precision for computation for 3D morphological operations.
    MorphologicalLaplacian::Precision precision() const;
    /// Sets the precision parameter.
    /// The precision for computation for 3D morphological operations.
    void setPrecision( const MorphologicalLaplacian::Precision& precision );

    /// Gets the kernelRadius parameter.
    /// The half size of the structuring element.@BRA structuring element always has an odd side length (3x3, 5x5, etc) which is defined by 2  elementSize + 1.
    int32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The half size of the structuring element.@BRA structuring element always has an odd side length (3x3, 5x5, etc) which is defined by 2  elementSize + 1.
    void setKernelRadius( const int32_t& kernelRadius );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Approximates an image Laplacian by using morphological operations.
/// @param inputImage The input image.
/// @param precision The precision for computation for 3D morphological operations.
/// @param kernelRadius The half size of the structuring element.@BRA structuring element always has an odd side length (3x3, 5x5, etc) which is defined by 2  elementSize + 1.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
morphologicalLaplacian( std::shared_ptr< iolink::ImageView > inputImage,
                        MorphologicalLaplacian::Precision precision,
                        int32_t kernelRadius,
                        std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
