/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs an edge-preserving smoothing of a three-dimensional image by selecting a mean value from different neighborhood configurations.
class IMAGEDEV_CPP_API NagaoFilter3d final : public GenericAlgorithm
{
public:
    /// The neighborhood selection criterion.
    enum FilterMethod
    {
    /// This option selects the mean of the neighborhood configuration of lower variance.
        VARIANCE = 0,
    /// This option selects the mean of the neighborhood configuration of lower intensity range.
        RANGE
    };

    // Command constructor.
    NagaoFilter3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the filterMethod parameter.
    /// The neighborhood selection criterion.
    NagaoFilter3d::FilterMethod filterMethod() const;
    /// Sets the filterMethod parameter.
    /// The neighborhood selection criterion.
    void setFilterMethod( const NagaoFilter3d::FilterMethod& filterMethod );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs an edge-preserving smoothing of a three-dimensional image by selecting a mean value from different neighborhood configurations.
/// @param inputImage The input image.
/// @param filterMethod The neighborhood selection criterion.
/// @param outputImage The output image. Its dimensions, type, and calibration are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
nagaoFilter3d( std::shared_ptr< iolink::ImageView > inputImage,
               NagaoFilter3d::FilterMethod filterMethod,
               std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
