/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/ArrayX.h>
#include <memory>

namespace imagedev
{
/// Extrudes a three-dimensional polyline in a given direction to produce a quadrilateral mesh surface.
class IMAGEDEV_CPP_API PolylineExtrusion3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    PolylineExtrusion3d();


    /// Gets the inputPolyline parameter.
    /// The input ArrayXd to extrude.
    std::shared_ptr<iolink::ArrayXd> inputPolyline() const;
    /// Sets the inputPolyline parameter.
    /// The input ArrayXd to extrude.
    void setInputPolyline( std::shared_ptr<iolink::ArrayXd> inputPolyline );

    /// Gets the forwardLength parameter.
    /// The extrusion length from the input polyline in the extrusion direction.
    double forwardLength() const;
    /// Sets the forwardLength parameter.
    /// The extrusion length from the input polyline in the extrusion direction.
    void setForwardLength( const double& forwardLength );

    /// Gets the backwardLength parameter.
    /// The extrusion length from the input polyline opposite to the extrusion direction.
    double backwardLength() const;
    /// Sets the backwardLength parameter.
    /// The extrusion length from the input polyline opposite to the extrusion direction.
    void setBackwardLength( const double& backwardLength );

    /// Gets the nodeCount parameter.
    /// Number of nodes to create along the whole extruded section along the sum of forward and backward lengths.
    uint32_t nodeCount() const;
    /// Sets the nodeCount parameter.
    /// Number of nodes to create along the whole extruded section along the sum of forward and backward lengths.
    void setNodeCount( const uint32_t& nodeCount );

    /// Gets the direction parameter.
    /// The extrusion direction.
    iolink::Vector3d direction() const;
    /// Sets the direction parameter.
    /// The extrusion direction.
    void setDirection( const iolink::Vector3d& direction );

    /// Gets the outputSurface parameter.
    /// The output surface.
    std::shared_ptr<iolink::ArrayXd> outputSurface() const;
    /// Sets the outputSurface parameter.
    /// The output surface.
    void setOutputSurface( std::shared_ptr<iolink::ArrayXd> outputSurface );

    // Method to launch the command.
    void execute();

};

/// Extrudes a three-dimensional polyline in a given direction to produce a quadrilateral mesh surface.
/// @param inputPolyline The input ArrayXd to extrude.
/// @param forwardLength The extrusion length from the input polyline in the extrusion direction.
/// @param backwardLength The extrusion length from the input polyline opposite to the extrusion direction.
/// @param nodeCount Number of nodes to create along the whole extruded section along the sum of forward and backward lengths.
/// @param direction The extrusion direction.
/// @param outputSurface The output surface.
/// @return Returns the outputSurface output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr<iolink::ArrayXd>
polylineExtrusion3d( std::shared_ptr<iolink::ArrayXd> inputPolyline,
                     double forwardLength,
                     double backwardLength,
                     uint32_t nodeCount,
                     const iolink::Vector3d& direction,
                     std::shared_ptr<iolink::ArrayXd> outputSurface = nullptr );
} // namespace imagedev
