/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Point detector removing spurs from a two-dimensional binary image.
class IMAGEDEV_CPP_API Pruning2d final : public GenericAlgorithm
{
public:
    /// The mode for removing end points.
    enum PruningMode
    {
    /// Each iteration removes only the end points having one neighbor. Using this mode, the pruning stops when an intersection or a right angle is encountered.
        RIGOROUS = 0,
    /// A skeletonization is reapplied between two iterations. Using this mode, only the closed-loops are kept.
        PERMISSIVE
    };

    // Command constructor.
    Pruning2d();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the pruningMode parameter.
    /// The mode for removing end points.
    Pruning2d::PruningMode pruningMode() const;
    /// Sets the pruningMode parameter.
    /// The mode for removing end points.
    void setPruningMode( const Pruning2d::PruningMode& pruningMode );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations. If equal to 0, the algorithm is run until convergence.
    int32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations. If equal to 0, the algorithm is run until convergence.
    void setNumberOfIterations( const int32_t& numberOfIterations );

    /// Gets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Point detector removing spurs from a two-dimensional binary image.
/// @param inputBinaryImage The binary input image.
/// @param pruningMode The mode for removing end points.
/// @param numberOfIterations The number of iterations. If equal to 0, the algorithm is run until convergence.
/// @param outputBinaryImage The binary output image. Its size and type are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
pruning2d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
           Pruning2d::PruningMode pruningMode,
           int32_t numberOfIterations,
           std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
