/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a subsampling of a two-dimensional image.
class IMAGEDEV_CPP_API SampleImage2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    SampleImage2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the sampleFactorX parameter.
    /// The X axis sampling factor.
    int32_t sampleFactorX() const;
    /// Sets the sampleFactorX parameter.
    /// The X axis sampling factor.
    void setSampleFactorX( const int32_t& sampleFactorX );

    /// Gets the sampleFactorY parameter.
    /// The Y axis sampling factor.
    int32_t sampleFactorY() const;
    /// Sets the sampleFactorY parameter.
    /// The Y axis sampling factor.
    void setSampleFactorY( const int32_t& sampleFactorY );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are equal to the input image dimensions divided by the sampling factor in each direction.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are equal to the input image dimensions divided by the sampling factor in each direction.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a subsampling of a two-dimensional image.
/// @param inputImage The input image.
/// @param sampleFactorX The X axis sampling factor.
/// @param sampleFactorY The Y axis sampling factor.
/// @param outputImage The output image. Its dimensions are equal to the input image dimensions divided by the sampling factor in each direction.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
sampleImage2d( std::shared_ptr< iolink::ImageView > inputImage,
               int32_t sampleFactorX,
               int32_t sampleFactorY,
               std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
