/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/ImageVolumeMsr.h>

namespace imagedev
{
/// Measures the volume of interest of a binary image.
class IMAGEDEV_CPP_API TotalImageVolume final : public GenericAlgorithm
{
public:

    // Command constructor.
    TotalImageVolume();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMaskImage parameter.
    /// The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    ImageVolumeMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Measures the volume of interest of a binary image.
/// @param inputImage The input image.
/// @param inputMaskImage The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
ImageVolumeMsr::Ptr
totalImageVolume( std::shared_ptr< iolink::ImageView > inputImage,
                  std::shared_ptr< iolink::ImageView > inputMaskImage,
                  ImageVolumeMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
