/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Sharpens edges on the elements of a two-dimensional image without increasing noise.
class IMAGEDEV_CPP_API UnsharpMasking3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    UnsharpMasking3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the edgeSize parameter.
    /// The radius of the desired edges in voxels, used as standard deviation of the Gaussian gradient.
    double edgeSize() const;
    /// Sets the edgeSize parameter.
    /// The radius of the desired edges in voxels, used as standard deviation of the Gaussian gradient.
    void setEdgeSize( const double& edgeSize );

    /// Gets the edgeContrast parameter.
    /// The contrast amount added at the edges.
    double edgeContrast() const;
    /// Sets the edgeContrast parameter.
    /// The contrast amount added at the edges.
    void setEdgeContrast( const double& edgeContrast );

    /// Gets the brightnessThreshold parameter.
    /// The minimum brightness threshold.
    double brightnessThreshold() const;
    /// Sets the brightnessThreshold parameter.
    /// The minimum brightness threshold.
    void setBrightnessThreshold( const double& brightnessThreshold );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Sharpens edges on the elements of a two-dimensional image without increasing noise.
/// @param inputImage The input image.
/// @param edgeSize The radius of the desired edges in voxels, used as standard deviation of the Gaussian gradient.
/// @param edgeContrast The contrast amount added at the edges.
/// @param brightnessThreshold The minimum brightness threshold.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
unsharpMasking3d( std::shared_ptr< iolink::ImageView > inputImage,
                  double edgeSize,
                  double edgeContrast,
                  double brightnessThreshold,
                  std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
