/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes, for each pixel of a two-dimensional image, the variation value of its neighborhood.
class IMAGEDEV_CPP_API VariationFilter2d final : public GenericAlgorithm
{
public:
    /// The shape of the window defining the neighborhood.
    enum KernelShape
    {
    /// The sliding window is a square.
        SQUARE = 0,
    /// The sliding window is a disk.
        DISK
    };

    // Command constructor.
    VariationFilter2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the kernelShape parameter.
    /// The shape of the window defining the neighborhood.
    VariationFilter2d::KernelShape kernelShape() const;
    /// Sets the kernelShape parameter.
    /// The shape of the window defining the neighborhood.
    void setKernelShape( const VariationFilter2d::KernelShape& kernelShape );

    /// Gets the kernelRadius parameter.
    /// The kernel half side length or radius, in pixels. In case of a square, a value N produces a square window of 2N+1 pixels side length. In case of a disk, a value N produces a disk with a 2N+1 pixels diameter.
    uint32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The kernel half side length or radius, in pixels. In case of a square, a value N produces a square window of 2N+1 pixels side length. In case of a disk, a value N produces a disk with a 2N+1 pixels diameter.
    void setKernelRadius( const uint32_t& kernelRadius );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Computes, for each pixel of a two-dimensional image, the variation value of its neighborhood.
/// @param inputImage The input image.
/// @param kernelShape The shape of the window defining the neighborhood.
/// @param kernelRadius The kernel half side length or radius, in pixels. In case of a square, a value N produces a square window of 2N+1 pixels side length. In case of a disk, a value N produces a disk with a 2N+1 pixels diameter.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
variationFilter2d( std::shared_ptr< iolink::ImageView > inputImage,
                   VariationFilter2d::KernelShape kernelShape,
                   uint32_t kernelRadius,
                   std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
