/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/VolumeFractionByLabelMsr.h>

namespace imagedev
{
/// Computes the volume fraction occupied by each object or region of a segmented image.
class IMAGEDEV_CPP_API VolumeFractionByLabel final : public GenericAlgorithm
{
public:

    // Command constructor.
    VolumeFractionByLabel();


    /// Gets the inputObjectImage parameter.
    /// The binary or label input image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The binary or label input image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputMaskImage parameter.
    /// The binary input image used as a mask (optional). Pixels having a zero value in the mask are not taken into account in the computations. If equal to null, the entire input image is considered as the mask. This image must have same dimensions as the main input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary input image used as a mask (optional). Pixels having a zero value in the mask are not taken into account in the computations. If equal to null, the entire input image is considered as the mask. This image must have same dimensions as the main input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement results for each label.
    VolumeFractionByLabelMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes the volume fraction occupied by each object or region of a segmented image.
/// @param inputObjectImage The binary or label input image.
/// @param inputMaskImage The binary input image used as a mask (optional). Pixels having a zero value in the mask are not taken into account in the computations. If equal to null, the entire input image is considered as the mask. This image must have same dimensions as the main input image.
/// @param outputMeasurement The output measurement results for each label.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
VolumeFractionByLabelMsr::Ptr
volumeFractionByLabel( std::shared_ptr< iolink::ImageView > inputObjectImage,
                       std::shared_ptr< iolink::ImageView > inputMaskImage,
                       VolumeFractionByLabelMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
