/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/ArrayX.h>
#include <memory>

namespace imagedev
{
/// Writes an ArrayXd object in a binary or text file.
class IMAGEDEV_CPP_API WriteArrayXd final : public GenericAlgorithm
{
public:
    /// The type of writting.
    enum WriteType
    {
    /// Writes as text.
        TEXT = 0,
    /// Writes as binary.
        BINARY
    };

    // Command constructor.
    WriteArrayXd();


    /// Gets the inputArrayXd parameter.
    /// The input ArrayXd object to write.
    std::shared_ptr<iolink::ArrayXd> inputArrayXd() const;
    /// Sets the inputArrayXd parameter.
    /// The input ArrayXd object to write.
    void setInputArrayXd( std::shared_ptr<iolink::ArrayXd> inputArrayXd );

    /// Gets the filePath parameter.
    /// The file path where the ArrayXd is written.
    std::string filePath() const;
    /// Sets the filePath parameter.
    /// The file path where the ArrayXd is written.
    void setFilePath( const std::string& filePath );

    /// Gets the writeType parameter.
    /// The type of writting.
    WriteArrayXd::WriteType writeType() const;
    /// Sets the writeType parameter.
    /// The type of writting.
    void setWriteType( const WriteArrayXd::WriteType& writeType );

    /// Gets the overwrite parameter.
    /// Allows the overwriting of an existing file.
    bool overwrite() const;
    /// Sets the overwrite parameter.
    /// Allows the overwriting of an existing file.
    void setOverwrite( const bool& overwrite );

    // Method to launch the command.
    void execute();

};

/// Writes an ArrayXd object in a binary or text file.
/// @param inputArrayXd The input ArrayXd object to write.
/// @param filePath The file path where the ArrayXd is written.
/// @param writeType The type of writting.
/// @param overwrite Allows the overwriting of an existing file.
/// @return Returns the None output parameter.
IMAGEDEV_CPP_API 
void
writeArrayXd( std::shared_ptr<iolink::ArrayXd> inputArrayXd,
              const std::string& filePath,
              WriteArrayXd::WriteType writeType,
              bool overwrite );
} // namespace imagedev
