// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/DataType.h>

namespace iolink
{

template <typename T>
class DataTypeTraits
{
public:
  using ScalarType = T;
  inline static DataType toDataType() { return DataTypeId::UNKNOWN; }
};

template <>
class DataTypeTraits<uint8_t>
{
public:
  using ScalarType = uint8_t;
  inline static DataType toDataType() { return DataTypeId::UINT8; }
};

template <>
class DataTypeTraits<uint16_t>
{
public:
  using ScalarType = uint16_t;
  inline static DataType toDataType() { return DataTypeId::UINT16; }
};

template <>
class DataTypeTraits<uint32_t>
{
public:
  using ScalarType = uint32_t;
  inline static DataType toDataType() { return DataTypeId::UINT32; }
};

template <>
class DataTypeTraits<uint64_t>
{
public:
  using ScalarType = uint64_t;
  inline static DataType toDataType() { return DataTypeId::UINT64; }
};

template <>
class DataTypeTraits<int8_t>
{
public:
  using ScalarType = int8_t;
  inline static DataType toDataType() { return DataTypeId::INT8; }
};

template <>
class DataTypeTraits<int16_t>
{
public:
  using ScalarType = int16_t;
  inline static DataType toDataType() { return DataTypeId::INT16; }
};

template <>
class DataTypeTraits<int32_t>
{
public:
  using ScalarType = int32_t;
  inline static DataType toDataType() { return DataTypeId::INT32; }
};

template <>
class DataTypeTraits<int64_t>
{
public:
  using ScalarType = int64_t;
  inline static DataType toDataType() { return DataTypeId::INT64; }
};

template <>
class DataTypeTraits<float>
{
public:
  using ScalarType = float;
  inline static DataType toDataType() { return DataTypeId::FLOAT; }
};

template <>
class DataTypeTraits<double>
{
public:
  using ScalarType = double;
  inline static DataType toDataType() { return DataTypeId::DOUBLE; }
};

template <>
class DataTypeTraits<const char*>
{
public:
  using ScalarType = const char*;
  inline static DataType toDataType() { return DataTypeId::UTF8_STRING; }
};

template <>
class DataTypeTraits<std::string>
{
public:
  using ScalarType = std::string;
  inline static DataType toDataType() { return DataTypeId::UTF8_STRING; }
};

template <>
class DataTypeTraits<std::u16string>
{
public:
  using ScalarType = std::string;
  inline static DataType toDataType() { return DataTypeId::UTF16_STRING; }
};

template <>
class DataTypeTraits<std::u32string>
{
public:
  using ScalarType = std::string;
  inline static DataType toDataType() { return DataTypeId::UTF32_STRING; }
};

template <typename T, size_t N>
class DataTypeTraits<Vector<T, N>>
{
public:
  using ScalarType = T;
  using ScalarTypeTraits = DataTypeTraits<T>;

  inline static DataType toDataType()
  {
    return DataType(ScalarTypeTraits::toDataType().primitiveType(),
                    N,
                    ScalarTypeTraits::toDataType().bitDepth(),
                    ScalarTypeTraits::toDataType().interpretation());
  }
};

} // end namespace iolink
