// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

/**
 * @namespace iolink
 *
 * @brief All IOLink symbols are enclosed in this namespace.
 */

#if defined(IOLINK_STATIC_BUILD)
#  define IOLINK_API
#  define IOLINK_API_EXPORT
#  define IOLINK_API_IMPORT
#  define IOLINK_INTERFACE_API
#else
#  if defined(_MSC_VER)
#    ifdef IOLINK_EXPORTS
#      define IOLINK_API_EXPORT __declspec(dllexport)
#      define IOLINK_API_IMPORT
#      define IOLINK_API IOLINK_API_EXPORT
#    else
#      define IOLINK_API_IMPORT __declspec(dllimport)
#      define IOLINK_API_EXPORT
#      define IOLINK_API IOLINK_API_IMPORT
#    endif
#    define IOLINK_INTERFACE_API
#  elif defined(__linux__) || defined(__APPLE__)
#    define IOLINK_API __attribute__((visibility("default")))
#    define IOLINK_API_EXPORT IOLINK_API
#    define IOLINK_API_IMPORT IOLINK_API
#    define IOLINK_INTERFACE_API IOLINK_API
#  else
#    define IOLINK_API
#    define IOLINK_API_EXPORT
#    define IOLINK_API_IMPORT
#    define IOLINK_INTERFACE_API
#  endif
#endif
