// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once
#include <iolink/IOLinkAPI.h>

#include <cstdint>
#include <string>

namespace iolink
{

/**
 * Class modeling universal resource identifier
 */

class IOLINK_API Uri final
{
public:
  /**
   * Parses string and sets uri fields
   */
  explicit Uri(const std::string& uri);

  Uri() = delete;

  /**
   * Asssignment Operator and Copy Constructor
   */
  Uri(const Uri& other);
  Uri& operator=(Uri rhs);

  /**
   * Destructor
   */
  ~Uri();

  /**
   * Scheme or protocol e.g. http, https, ftp
   */
  std::string scheme() const;

  /**
   * Returns the authority part (userInfo, host and port) of the URI.
   */
  std::string authority() const;

  /**
   * Returns the host part of the URI.
   */
  std::string host() const;

  /**
   * Returns the port number part of the URI.
   */
  uint16_t port() const;

  /**
   * Returns the user-info part of the URI.
   */
  std::string userInfo() const;

  /**
   * Returns the decoded path part of the URI.
   */
  std::string path() const;

  /**
   * Returns the decoded query part of the URI.
   */
  std::string query() const;

  /**
   * Returns the encoded path and query parts of the URI.
   */
  std::string pathAndQuery() const;

  /**
   * Returns a string representation of the URI.
   */
  std::string toString() const;

private:
  // Internal implementation class
  class Impl;

  // Pointer to the internal implementation
  Impl* m_pimpl;
};

} // end namespace iolink
