// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <cstdint>

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/VariantDataValue.h>

namespace iolink
{

/**
 * A factory to create VariantDataValue instances from a great variety of types.
 */
class IOLINK_API VariantDataValueFactory
{
  VariantDataValueFactory() = delete;
  VariantDataValueFactory(const VariantDataValueFactory& other) = delete;            // copy constructor
  VariantDataValueFactory(VariantDataValueFactory&& other) = delete;                 // move constructor
  VariantDataValueFactory& operator=(const VariantDataValueFactory& other) = delete; // copy assignment
  VariantDataValueFactory& operator=(VariantDataValueFactory&& other) = delete;      // move assignment

public:
  static std::shared_ptr<VariantDataValue> create(uint8_t value);
  static std::shared_ptr<VariantDataValue> create(uint16_t value);
  static std::shared_ptr<VariantDataValue> create(uint32_t value);
  static std::shared_ptr<VariantDataValue> create(uint64_t value);

  static std::shared_ptr<VariantDataValue> create(int8_t value);
  static std::shared_ptr<VariantDataValue> create(int16_t value);
  static std::shared_ptr<VariantDataValue> create(int32_t value);
  static std::shared_ptr<VariantDataValue> create(int64_t value);

  static std::shared_ptr<VariantDataValue> create(float value);
  static std::shared_ptr<VariantDataValue> create(double value);

  static std::shared_ptr<VariantDataValue> create(const char* value);
  static std::shared_ptr<VariantDataValue> create(const std::string& value);

  //============================================================================

  static std::shared_ptr<VariantDataValue> create(const uint8_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const uint16_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const uint32_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const uint64_t* values, size_t count);

  static std::shared_ptr<VariantDataValue> create(const int8_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const int16_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const int32_t* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const int64_t* values, size_t count);

  static std::shared_ptr<VariantDataValue> create(const float* values, size_t count);
  static std::shared_ptr<VariantDataValue> create(const double* values, size_t count);

  static std::shared_ptr<VariantDataValue> create(const char** values, size_t count);
};

} // end namespace iolink
