// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <cstdint>
#include <string>

#include <iolink/IOLinkAPI.h>
#include <iolink/Version.h>

namespace iolink
{

/**
 * Versioning tool to check library infos.
 */
class IOLINK_API Versioning
{
public:
  /**
   * Return the version of the currently loaded IOLink library.
   */
  static VersionInfo version();

  /**
   * Return a description string of the currently loaded IOLink library.
   */
  static std::string versionString();

  /**
   * Check if the loaded library'version is compatible with the given one.
   *
   * A version is compatible if:
   *  - The major version is the same
   *  - The library minor version is greater than the given one.
   *
   * @param version The version to check compatibility for.
   */
  static bool checkCompatibility(const VersionInfo& version);

  /**
   * Check if the loaded library is compatible with the one defined in the header.
   */
  static inline bool checkCompatibility() { return checkCompatibility(IOLINK_VERSION); }
};

} // end namespace iolink
