#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/cuda/CudaImageExtension.h>
#include <iolink/cuda/api.h>
#include <iolink/view/ImageView.h>

namespace iolink_cuda
{

class IOLINK_CUDA_API CudaExtensionProvider
{
public:
  CudaExtensionProvider() = delete;
  CudaExtensionProvider(const CudaExtensionProvider& other) = delete;            // copy constructor
  CudaExtensionProvider(CudaExtensionProvider&& other) = delete;                 // move constructor
  CudaExtensionProvider& operator=(const CudaExtensionProvider& other) = delete; // copy assignment
  CudaExtensionProvider& operator=(CudaExtensionProvider&& other) = delete;      // move assignment

  /**
   * Returns cuda image extension from given ImageViews.
   *
   * @return cuda image extension if given image is a CUDA image
   * @return nullptr otherwise
   */
  static std::shared_ptr<CudaImageExtension> cudaImage(std::shared_ptr<iolink::ImageView> image);

  /**
   * Returns if given image is a CUDA image.
   */
  static bool isCudaImage(std::shared_ptr<iolink::ImageView> image);
};

} // namespace iolink_cuda
