// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <array>
#include <initializer_list>
#include <string>

#include <iolink/IOLinkAPI.h>

namespace iolink
{

/**
 * A class used to pass HTTP headers as input of factories methods.
 */
class IOLINK_API HTTPHeaders
{
public:
  /**
   * An entry of the HTTP header set.
   */
  struct Entry
  {
    std::string name;
    std::string value;
  };

  /**
   * Create an empty set of headers.
   */
  HTTPHeaders();

  /**
   * Initialize the headers from an array of entries.
   *
   * @param values A pointer to the first element of the array.
   * @param count The number of element in the array.
   */
  HTTPHeaders(const Entry* values, size_t count);

  /**
   * Initialize headers from an initializer list.
   */
  explicit HTTPHeaders(std::initializer_list<Entry> init);

  HTTPHeaders(const HTTPHeaders& other);
  HTTPHeaders& operator=(const HTTPHeaders& other);

  HTTPHeaders(HTTPHeaders&& other) noexcept;
  HTTPHeaders& operator=(HTTPHeaders&& other) noexcept;

  ~HTTPHeaders();

  /**
   * Return the number of entries in this headers set.
   */
  size_t size() const;

  /**
   * Return the element at the given index.
   */
  Entry at(size_t i) const;

  /**
   * Return the element at the given index.
   */
  inline Entry operator[](size_t i) const { return at(i); }

  /**
   * Add a new entry in the header set.
   */
  void add(const Entry& entry);

  /**
   * Add a new entry in the hedaer set by giving its name and value.
   */
  inline void add(const std::string& name, const std::string& value) { add(Entry{name, value}); }

private:
  class Private;
  Private* m_private;
};

} // namespace iolink
