// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/IOLinkAPI.h>
#include <iolink/storage/RandomAccess.h>

#include <memory>

namespace iolink
{

/**
 * Utility class to check and convert a DataAccess into a RandomAccess.
 */
class IOLINK_INTERFACE_API RandomAccessProvider
{
public:
  /**
   * Checks if DataAccess supports RandomAccess interface.
   */
  inline static bool isRandomAccess(std::shared_ptr<DataAccess> randomAccess) noexcept
  {
    return (dynamic_cast<const RandomAccess*>(randomAccess.get()) != nullptr);
  }

  /**
   * Return the RandomAccess interface if the accessor supports it.
   *
   * If it does not support this interface, returns null.
   */
  inline static std::shared_ptr<RandomAccess> toRandom(std::shared_ptr<DataAccess> accessor) noexcept
  {
    return std::dynamic_pointer_cast<RandomAccess>(accessor);
  }
};

} // end namespace iolink
