// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/view/ImageView.h>

namespace iolink
{

/**
 * Utility class to check and convert a View into an ImagevView.
 */
class IOLINK_API ImageViewProvider
{
public:
  //============================================================================
  // Checking ImageView's capacities
  //============================================================================

  /**
   * Checks if a given View is an ImageView.
   */
  inline static bool isImage(std::shared_ptr<View> view) noexcept
  {
    return (dynamic_cast<const ImageView*>(view.get()) != nullptr);
  }

  //============================================================================
  // Access to capacities interfaces
  //============================================================================

  /**
   * Extracts the ImageView interface from a given generic view.
   *
   * If the given view is not an ImageView, this method will return null.
   */
  inline static std::shared_ptr<ImageView> toImage(std::shared_ptr<View> view) noexcept
  {
    return std::dynamic_pointer_cast<ImageView>(view);
  }

  /**
   * Remove all capacities except READ to an ImageView.
   * If given ImageView only has READ capacity, it is returned directly.
   * @param image ImageView for which we want to only have READ capacity
   * @return an ImageView with only READ capacity
   */
  static std::shared_ptr<ImageView> toReadOnly(std::shared_ptr<ImageView> image);

  /**
   * Remove all capacities except WRITE to an ImageView.
   * If given ImageView only has WRITE capacity, it is returned directly.
   * @param image ImageView for which we want to only have WRITE capacity
   * @return an ImageView with only WRITE capacity
   */
  static std::shared_ptr<ImageView> toWriteOnly(std::shared_ptr<ImageView> image);
};

} // end namespace iolink
