// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/RegionX.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace iolink
{
/**
 * A view on an image with multiple levels of detail (LOD).
 *
 * It is also usually called a pyramid of resolutions
 *   - level 0 always gives the original resolution of the image
 *   - image resolution at level N+1 is always lower than resolution at level N
 *
 */
class IOLINK_API LodImageView : public View
{
public:
  virtual ~LodImageView() = default;

  /**
   * Give the range of available levels of resolution
   * Level 0 is always in the range. (because it corresponds to the original image)
   * First value of returned vector is the level corresponding to the highest resolution (inferior or equal to 0)
   * Second value of returned vector is the level corresponding to the lowest resolution (superior or equal to 0)
   *   - a negative level (< 0) gives a higher resolution of the original image
   *   - a positive (> 0) level gives a lower resolution of the original image
   *
   * @return a vector of 2 values (high-res level, low-res level)
   */
  virtual const Vector2i64& levelRange() = 0;

  /**
   * An ImageView of the n-th level of detail.
   *
   * @param level the level of detail
   * @return ImageView corresponding to given level
   * @throw Error if required level is not handled (out of range)
   */
  virtual std::shared_ptr<ImageView> resolution(int64_t level) = 0;

  /**
   * Return a string representation
   */
  std::string toString() const;
};

} // end namespace iolink
