// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/IOLinkAPI.h>
#include <iolink/VariantDataValue.h>

namespace iolink
{

/**
 * Interface to use in order to output a view to another medium.
 */
class IOLINK_API Writer
{
public:
  virtual ~Writer() = default;

  /**
   * Output all the data.
   */
  virtual void writeAll() = 0;

  /**
   * Initialize file and output only the header
   */
  virtual void writeInit() = 0;

  /**
   * Output the data. Should be called between writeInit() and writeFinish().
   */
  virtual void writeData() = 0;

  /**
   * Write footer (if any) and finalize file. Should be called after writeData().
   */
  virtual void writeFinish() = 0;

  /**
   * Returns the name of the writer
   */
  virtual std::string name() const = 0;

  /**
   * Returns the version of the writer
   */
  virtual std::string version() const = 0;

  /**
   * Set an option value to writer
   *
   * @param parameter name of parameter whose value must be set
   * @param data value to set for the given parameter. Must be built with MetadataValue factory
   *
   * @throw Error if parameter is not known or given data is not valid
   */
  virtual void setOption(const std::string& parameter, std::shared_ptr<VariantDataValue> data) = 0;

  /**
   * Return a string representation
   */
  std::string toString() const;
};

} // end namespace iolink
