/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Breadth3d.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Cooccurrence.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Feret2d.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Feret3d.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Histogram.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/NeighborCount.h>
#include <ImageDev/Data/AnalysisMeasurements/MeasurementAttributes/Quantile.h>

namespace imagedev {

/// This class gives access to specific parameters applicable to customizable measurements.
class IMAGEDEV_CPP_API MeasurementAttributes
{
public:
    /// Gets the attribute defining the neighborhood of a particles with the Breadth3d measurement.
    static Breadth3d::Ptr breadth3d();

    /// Gets the attribute managing measurements belonging to the Cooccurrence category of native measurements.
    static Cooccurrence::Ptr cooccurrence();

    /// Gets the attribute managing two-dimensional measurements belonging to the Feret category of native measurements.
    static Feret2d::Ptr feret2d();

    /// Gets the attribute managing three-dimensional measurements belonging to the Feret category of native
    /// measurements.
    static Feret3d::Ptr feret3d();

    /// Gets the attribute defining the neighborhood of a particles with the NeighborCount measurement.
    static NeighborCount::Ptr neighborCount();

    /// Gets the attribute managing quantile measurements belonging to the Histogram category of native measurements.
    static Quantile::Ptr quantile();

    /// Gets the attribute managing measurements belonging to the Histogram category of native measurements.
    static Histogram::Ptr histogram();
};

} // namespace imagedev
