/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <memory>

namespace imagedev {

/// This attribute manages measurements belonging to the Cooccurrence category of native measurements.
class IMAGEDEV_CPP_API Cooccurrence
{
public:
    typedef std::shared_ptr< Cooccurrence > Ptr;

    /// Internal constructor
    Cooccurrence(){};

    /// Sets the number of offset vectors; that is, the number of cooccurrence matrices to compute.
    void setVectorCount( size_t number );
    /// Returns the number of offset vectors; that is, the number of cooccurrence matrices to compute.
    size_t vectorCount() const;

    /// Adds an offset vector defined by x and y displacements in pixels.
    void addVector( int32_t dx, int32_t dy );
    /// Returns the offset vector at the index position.
    iolink::Vector2i32 vector( int32_t index ) const;

    /// Enables or disables the automatic computation of the joint histogram range.
    void setAutoAdjusted( bool autoAdjusted );
    /// Returns true if the range of the joint histogram is automatically determined, false otherwise.
    bool isAutoAdjusted() const;

    /// Sets the histogram bin size. It must be strictly positive. It is ignored when the automatic mode is disabled.
    void setBinSize( float size );
    /// Returns the bin size of the joint histogram. This parameter is ignored is the automatic mode is disabled.
    float binSize() const;

    /// Sets the minimum gray level value used to compute the joint histogram.
    /// This parameter is ignored if the automatic mode is disabled.
    void setMinIntensity( float value );
    /// Returns the minimum gray level value used to compute the joint histogram.
    /// This parameter is ignored if the automatic mode is disabled.
    float minIntensity() const;

    /// Sets the maximum gray level value used to compute the joint histogram.
    /// This parameter is ignored if the automatic mode is disabled.
    void setMaxIntensity( float value );
    /// Returns the maximum gray level value used to compute the joint histogram.
    /// This parameter is ignored if the automatic mode is disabled.
    float maxIntensity();
};

} // namespace imagedev
