/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct CorrelationMsrPrivate;

/// Contains the position of the main correlation peak detected in an image and other information related to the correlation computation.
/// This object is generated by the imagedev::Correlation algorithm and the imagedev::correlation function.
class IMAGEDEV_CPP_API CorrelationMsr
{
public:
    typedef CorrelationMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~CorrelationMsr();

    /// Writes the CorrelationMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the CorrelationMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The CorrelationMsr measurement read.
    static CorrelationMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the minComputed measurement.
    double minComputed( size_t time = 0 ) const;
    const FieldInformation & minComputedInformation() const;

    /// Gets a result of the maxComputed measurement.
    double maxComputed( size_t time = 0 ) const;
    const FieldInformation & maxComputedInformation() const;

    /// Gets a result of the matchingPositionX measurement.
    double matchingPositionX( size_t time = 0 ) const;
    const FieldInformation & matchingPositionXInformation() const;

    /// Gets a result of the matchingPositionY measurement.
    double matchingPositionY( size_t time = 0 ) const;
    const FieldInformation & matchingPositionYInformation() const;

    /// Gets a result of the minTheoretical measurement.
    double minTheoretical( size_t time = 0 ) const;
    const FieldInformation & minTheoreticalInformation() const;

    /// Gets a result of the maxTheoretical measurement.
    double maxTheoretical( size_t time = 0 ) const;
    const FieldInformation & maxTheoreticalInformation() const;

private:
    friend struct CorrelationMsrPrivate;
    CorrelationMsr( object_model::Dictionary* );
    CorrelationMsrPrivate* m_p;
};

} // namespace imagedev
