/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct TextureClassificationModelPrivate;

/// Contains all the information necessary to run a trained machine learning model for performing a texture-based segmentation.
/// This object is generated by the imagedev::TextureClassificationMo algorithm and the imagedev::textureClassificationMo function.
class IMAGEDEV_CPP_API TextureClassificationModel
{
public:
    typedef TextureClassificationModel Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~TextureClassificationModel();

    /// Writes the TextureClassificationModel measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the TextureClassificationModel measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The TextureClassificationModel measurement read.
    static TextureClassificationModel::Ptr read( const std::string& pathName );

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the computeMode measurement.
    std::string computeMode(  ) const;
    const FieldInformation & computeModeInformation() const;

    /// Gets a result of the coocRadius measurement.
    uint64_t coocRadius(  ) const;
    const FieldInformation & coocRadiusInformation() const;

    /// Gets a result of the coocTextonShape measurement.
    std::string coocTextonShape(  ) const;
    const FieldInformation & coocTextonShapeInformation() const;

    /// Gets a result of the featureGroup measurement.
    std::string featureGroup( size_t radiusIndex = 0 ) const;
    const FieldInformation & featureGroupInformation() const;

    /// Gets a result of the listOfRadius measurement.
    uint64_t listOfRadius( size_t radiusIndex = 0 ) const;
    const FieldInformation & listOfRadiusInformation() const;

    /// Gets a result of the numOfClasses measurement.
    uint64_t numOfClasses(  ) const;
    const FieldInformation & numOfClassesInformation() const;

    /// Gets a result of the selectedFeature measurement.
    std::string selectedFeature( size_t featureIndex = 0 ) const;
    const FieldInformation & selectedFeatureInformation() const;

    /// Gets a result of the separationPower measurement.
    double separationPower(  ) const;
    const FieldInformation & separationPowerInformation() const;

private:
    friend struct TextureClassificationModelPrivate;
    TextureClassificationModel( object_model::Dictionary* );
    TextureClassificationModelPrivate* m_p;
};

} // namespace imagedev
