/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a three-dimensional closing using a structuring element matching with an oriented disk.
class IMAGEDEV_CPP_API ClosingDisk3d final : public GenericAlgorithm
{
public:
    /// The border policy to apply.
    enum BorderPolicy
    {
    /// The limited mode is faster to compute, but can produce the unexpected results for particles close to the image border.
        LIMITED = 0,
    /// The Extended mode is slower to compute, but produces the expected results for particles close to the image border.
        EXTENDED
    };

    // Command constructor.
    ClosingDisk3d();


    /// Gets the inputImage parameter.
    /// The input image. The image type can be integer or float. Default is NULL.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image. The image type can be integer or float. Default is NULL.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the thetaAngle parameter.
    /// The azimuthal angle in degrees.
    double thetaAngle() const;
    /// Sets the thetaAngle parameter.
    /// The azimuthal angle in degrees.
    void setThetaAngle( const double& thetaAngle );

    /// Gets the phiAngle parameter.
    /// The polar angle in degrees.
    double phiAngle() const;
    /// Sets the phiAngle parameter.
    /// The polar angle in degrees.
    void setPhiAngle( const double& phiAngle );

    /// Gets the kernelRadius parameter.
    /// The length of the disk radius in voxels.
    uint32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The length of the disk radius in voxels.
    void setKernelRadius( const uint32_t& kernelRadius );

    /// Gets the borderPolicy parameter.
    /// The border policy to apply.
    ClosingDisk3d::BorderPolicy borderPolicy() const;
    /// Sets the borderPolicy parameter.
    /// The border policy to apply.
    void setBorderPolicy( const ClosingDisk3d::BorderPolicy& borderPolicy );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a three-dimensional closing using a structuring element matching with an oriented disk.
/// @param inputImage The input image. The image type can be integer or float. Default is NULL.
/// @param thetaAngle The azimuthal angle in degrees.
/// @param phiAngle The polar angle in degrees.
/// @param kernelRadius The length of the disk radius in voxels.
/// @param borderPolicy The border policy to apply.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
closingDisk3d( std::shared_ptr< iolink::ImageView > inputImage,
               double thetaAngle,
               double phiAngle,
               uint32_t kernelRadius,
               ClosingDisk3d::BorderPolicy borderPolicy,
               std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
