/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the colorToGrayscale function.
struct ColorToGrayscaleOutput
{
    /// The first channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage1;
    /// The second channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage2;
    /// The third channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage3;
};

/// Separates a color image into its three grayscale components.
class IMAGEDEV_CPP_API ColorToGrayscale final : public GenericAlgorithm
{
public:

    // Command constructor.
    ColorToGrayscale();


    /// Gets the inputColorImage parameter.
    /// The color input image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The color input image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the outputGrayImage1 parameter.
    /// The first channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage1() const;
    /// Sets the outputGrayImage1 parameter.
    /// The first channel output image. Its spatial dimensions and type are forced to the same values as the input.
    void setOutputGrayImage1( std::shared_ptr< iolink::ImageView > outputGrayImage1 );

    /// Gets the outputGrayImage2 parameter.
    /// The second channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage2() const;
    /// Sets the outputGrayImage2 parameter.
    /// The second channel output image. Its spatial dimensions and type are forced to the same values as the input.
    void setOutputGrayImage2( std::shared_ptr< iolink::ImageView > outputGrayImage2 );

    /// Gets the outputGrayImage3 parameter.
    /// The third channel output image. Its spatial dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputGrayImage3() const;
    /// Sets the outputGrayImage3 parameter.
    /// The third channel output image. Its spatial dimensions and type are forced to the same values as the input.
    void setOutputGrayImage3( std::shared_ptr< iolink::ImageView > outputGrayImage3 );

    // Method to launch the command.
    void execute();

};

/// Separates a color image into its three grayscale components.
/// @param inputColorImage The color input image.
/// @param outputGrayImage1 The first channel output image. Its spatial dimensions and type are forced to the same values as the input.
/// @param outputGrayImage2 The second channel output image. Its spatial dimensions and type are forced to the same values as the input.
/// @param outputGrayImage3 The third channel output image. Its spatial dimensions and type are forced to the same values as the input.
/// @return Returns a ColorToGrayscaleOutput structure containing the outputGrayImage1, outputGrayImage2 and outputGrayImage3 output parameters.
IMAGEDEV_CPP_API 
ColorToGrayscaleOutput
colorToGrayscale( std::shared_ptr< iolink::ImageView > inputColorImage,
                  std::shared_ptr< iolink::ImageView > outputGrayImage1 = nullptr,
                  std::shared_ptr< iolink::ImageView > outputGrayImage2 = nullptr,
                  std::shared_ptr< iolink::ImageView > outputGrayImage3 = nullptr );
} // namespace imagedev
