/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/CoocurrrenceMsr.h>

namespace imagedev
{
/// Provides texture indicators, also known as Haralick features, based on the computation of co-occurrence matrix.
class IMAGEDEV_CPP_API Cooccurrence2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    Cooccurrence2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMaskImage parameter.
    /// The binary mask image where co-occurrence is computed. If it equals null, computations are performed on all pixels of the input image. This image must have the same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary mask image where co-occurrence is computed. If it equals null, computations are performed on all pixels of the input image. This image must have the same dimensions as the input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the offsetX parameter.
    /// The X offset defining the co-occurrence vector.
    int32_t offsetX() const;
    /// Sets the offsetX parameter.
    /// The X offset defining the co-occurrence vector.
    void setOffsetX( const int32_t& offsetX );

    /// Gets the offsetY parameter.
    /// The Y offset defining the co-occurrence vector.
    int32_t offsetY() const;
    /// Sets the offsetY parameter.
    /// The Y offset defining the co-occurrence vector.
    void setOffsetY( const int32_t& offsetY );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result object containing the haralick features.
    CoocurrrenceMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Provides texture indicators, also known as Haralick features, based on the computation of co-occurrence matrix.
/// @param inputImage The input image.
/// @param inputMaskImage The binary mask image where co-occurrence is computed. If it equals null, computations are performed on all pixels of the input image. This image must have the same dimensions as the input image.
/// @param offsetX The X offset defining the co-occurrence vector.
/// @param offsetY The Y offset defining the co-occurrence vector.
/// @param outputMeasurement The output measurement result object containing the haralick features.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
CoocurrrenceMsr::Ptr
cooccurrence2d( std::shared_ptr< iolink::ImageView > inputImage,
                std::shared_ptr< iolink::ImageView > inputMaskImage,
                int32_t offsetX,
                int32_t offsetY,
                CoocurrrenceMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
