/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Extracts a three-dimensional rectangular region from an image.
class IMAGEDEV_CPP_API CropImage3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    CropImage3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the areaOrigin parameter.
    /// The origin of the area (the X, Y, and Z voxel coordinates of the input image corresponding to the output image origin).
    iolink::Vector3i32 areaOrigin() const;
    /// Sets the areaOrigin parameter.
    /// The origin of the area (the X, Y, and Z voxel coordinates of the input image corresponding to the output image origin).
    void setAreaOrigin( const iolink::Vector3i32& areaOrigin );

    /// Gets the areaSize parameter.
    /// The size, in voxels, of the area (the X, Y, and Z dimensions of the output image).
    iolink::Vector3i32 areaSize() const;
    /// Sets the areaSize parameter.
    /// The size, in voxels, of the area (the X, Y, and Z dimensions of the output image).
    void setAreaSize( const iolink::Vector3i32& areaSize );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Extracts a three-dimensional rectangular region from an image.
/// @param inputImage The input image.
/// @param areaOrigin The origin of the area (the X, Y, and Z voxel coordinates of the input image corresponding to the output image origin).
/// @param areaSize The size, in voxels, of the area (the X, Y, and Z dimensions of the output image).
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
cropImage3d( std::shared_ptr< iolink::ImageView > inputImage,
             const iolink::Vector3i32& areaOrigin,
             const iolink::Vector3i32& areaSize,
             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
