/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Smooths a three-dimensional image by replacing any aberrant voxel values by their neighbors mean value.
class IMAGEDEV_CPP_API Despeckle3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    Despeckle3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the kernelSizeX parameter.
    /// The horizontal kernel size in voxels (odd value).
    int32_t kernelSizeX() const;
    /// Sets the kernelSizeX parameter.
    /// The horizontal kernel size in voxels (odd value).
    void setKernelSizeX( const int32_t& kernelSizeX );

    /// Gets the kernelSizeY parameter.
    /// The vertical kernel size in voxels (odd value).
    int32_t kernelSizeY() const;
    /// Sets the kernelSizeY parameter.
    /// The vertical kernel size in voxels (odd value).
    void setKernelSizeY( const int32_t& kernelSizeY );

    /// Gets the kernelSizeZ parameter.
    /// The depth kernel size in voxels (odd value).
    int32_t kernelSizeZ() const;
    /// Sets the kernelSizeZ parameter.
    /// The depth kernel size in voxels (odd value).
    void setKernelSizeZ( const int32_t& kernelSizeZ );

    /// Gets the thresholdFactor parameter.
    /// The standard deviation threshold factor (must be a positive value).
    double thresholdFactor() const;
    /// Sets the thresholdFactor parameter.
    /// The standard deviation threshold factor (must be a positive value).
    void setThresholdFactor( const double& thresholdFactor );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Smooths a three-dimensional image by replacing any aberrant voxel values by their neighbors mean value.
/// @param inputImage The input image.
/// @param kernelSizeX The horizontal kernel size in voxels (odd value).
/// @param kernelSizeY The vertical kernel size in voxels (odd value).
/// @param kernelSizeZ The depth kernel size in voxels (odd value).
/// @param thresholdFactor The standard deviation threshold factor (must be a positive value).
/// @param outputImage The output image. Its dimensions, type, and calibration are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
despeckle3d( std::shared_ptr< iolink::ImageView > inputImage,
             int32_t kernelSizeX,
             int32_t kernelSizeY,
             int32_t kernelSizeZ,
             double thresholdFactor,
             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
