/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Finds the shortest path through an image, considering the image intensities as weights.
class IMAGEDEV_CPP_API DijkstraShortestPath2d final : public GenericAlgorithm
{
public:
    /// The direction of the searched path.
    enum Axis
    {
    /// The shortest path is searched through the X axis. @BR
        X_AXIS = 0,
    /// The shortest path is searched through the Y axis. @BR@BR
        Y_AXIS
    };
    /// The type of enclosed objects.
    enum IntensityMode
    {
    /// The shortest path is searched through the intensity maxima pixels. @BR
        BRIGHT = 0,
    /// The shortest path is searched through the intensity minima pixels. @BR
        DARK
    };

    // Command constructor.
    DijkstraShortestPath2d();


    /// Gets the inputGrayImage parameter.
    /// The grayscale input image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// The grayscale input image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the inputMaskImage parameter.
    /// The binary input image for the mask.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary input image for the mask.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the axis parameter.
    /// The direction of the searched path.
    DijkstraShortestPath2d::Axis axis() const;
    /// Sets the axis parameter.
    /// The direction of the searched path.
    void setAxis( const DijkstraShortestPath2d::Axis& axis );

    /// Gets the intensityMode parameter.
    /// The type of enclosed objects.
    DijkstraShortestPath2d::IntensityMode intensityMode() const;
    /// Sets the intensityMode parameter.
    /// The type of enclosed objects.
    void setIntensityMode( const DijkstraShortestPath2d::IntensityMode& intensityMode );

    /// Gets the outputBinaryImage parameter.
    /// The binary output image.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The binary output image.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Finds the shortest path through an image, considering the image intensities as weights.
/// @param inputGrayImage The grayscale input image.
/// @param inputMaskImage The binary input image for the mask.
/// @param axis The direction of the searched path.
/// @param intensityMode The type of enclosed objects.
/// @param outputBinaryImage The binary output image.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
dijkstraShortestPath2d( std::shared_ptr< iolink::ImageView > inputGrayImage,
                        std::shared_ptr< iolink::ImageView > inputMaskImage,
                        DijkstraShortestPath2d::Axis axis,
                        DijkstraShortestPath2d::IntensityMode intensityMode,
                        std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
