/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Combines two images following a direction axis.
class IMAGEDEV_CPP_API DirectionalBlending2d final : public GenericAlgorithm
{
public:
    /// The guiding axis to perform the blending.
    enum Axis
    {
    /// The blending is performed along the horizontal axis.@Ul @Li The first column of the output image is filled with 100% of the first input image intensities. @li @Li The last column of the output image is filled with 100% of the second input image intensities. @li @Li The middle column of the output image is filled with 50% of the first input and 50% of the second input image intensities. @li @Li Other columns are filled by a linear combination of both input image intensities. @li @ul
        X_AXIS = 0,
    /// The blending is performed along the vertical axis.@Ul @Li The first row of the output image is filled with 100% of the first input image intensities. @li @Li The last row of the output image is filled with 100% of the second input image intensities. @li @Li The middle row of the output image is filled with 50% of the first input and 50% of the second input image intensities. @li @Li Other rows are filled by a linear combination of both input image intensities. @li @ul
        Y_AXIS
    };

    // Command constructor.
    DirectionalBlending2d();


    /// Gets the inputImage1 parameter.
    /// The first input image.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image (must have same dimensions and type as the first input).
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image (must have same dimensions and type as the first input).
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the axis parameter.
    /// The guiding axis to perform the blending.
    DirectionalBlending2d::Axis axis() const;
    /// Sets the axis parameter.
    /// The guiding axis to perform the blending.
    void setAxis( const DirectionalBlending2d::Axis& axis );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the inputs.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the inputs.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Combines two images following a direction axis.
/// @param inputImage1 The first input image.
/// @param inputImage2 The second input image (must have same dimensions and type as the first input).
/// @param axis The guiding axis to perform the blending.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the inputs.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
directionalBlending2d( std::shared_ptr< iolink::ImageView > inputImage1,
                       std::shared_ptr< iolink::ImageView > inputImage2,
                       DirectionalBlending2d::Axis axis,
                       std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
