/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Point detector selecting end points of a two-dimensional binary image.
class IMAGEDEV_CPP_API EndPoints2d final : public GenericAlgorithm
{
public:
    /// The way to consider pixels out of image borders.
    enum BorderCondition
    {
    /// Pixels outside of the image are considered as having the value 0.
        ZERO = 0,
    /// Pixels outside of the image are considered as an extrapolation of the image pixels with a mirror border condition.
        MIRROR
    };
    /// The 2D neighborhood configuration for performing dilations or erosions.
    enum Neighborhood
    {
    /// The structuring element is a cross.
        CONNECTIVITY_4 = 0,
    /// The structuring element is a square.
        CONNECTIVITY_8
    };

    // Command constructor.
    EndPoints2d();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the borderCondition parameter.
    /// The way to consider pixels out of image borders.
    EndPoints2d::BorderCondition borderCondition() const;
    /// Sets the borderCondition parameter.
    /// The way to consider pixels out of image borders.
    void setBorderCondition( const EndPoints2d::BorderCondition& borderCondition );

    /// Gets the neighborhood parameter.
    /// The 2D neighborhood configuration for performing dilations or erosions.
    EndPoints2d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 2D neighborhood configuration for performing dilations or erosions.
    void setNeighborhood( const EndPoints2d::Neighborhood& neighborhood );

    /// Gets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Point detector selecting end points of a two-dimensional binary image.
/// @param inputBinaryImage The binary input image.
/// @param borderCondition The way to consider pixels out of image borders.
/// @param neighborhood The 2D neighborhood configuration for performing dilations or erosions.
/// @param outputBinaryImage The binary output image. Its size and type are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
endPoints2d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
             EndPoints2d::BorderCondition borderCondition,
             EndPoints2d::Neighborhood neighborhood,
             std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
