/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs an iterative dilation of a label image, until the entire background is filled by labels.
class IMAGEDEV_CPP_API ExpandLabelsOnBackground final : public GenericAlgorithm
{
public:
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    enum Neighborhood
    {
    /// The structuring element is composed of voxels with a common face with the voxel of interest.
        CONNECTIVITY_6 = 0,
    /// The structuring element is composed of voxels with at least one common edge.
        CONNECTIVITY_18,
    /// The structuring element is a full cube.
        CONNECTIVITY_26
    };

    // Command constructor.
    ExpandLabelsOnBackground();


    /// Gets the inputLabelImage parameter.
    /// The input label image.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The input label image.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the neighborhood parameter.
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    ExpandLabelsOnBackground::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
    void setNeighborhood( const ExpandLabelsOnBackground::Neighborhood& neighborhood );

    /// Gets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input image.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image. Its dimensions are forced to the same values as the input image.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Performs an iterative dilation of a label image, until the entire background is filled by labels.
/// @param inputLabelImage The input label image.
/// @param neighborhood The 3D neighborhood configuration. This parameter is ignored with a 2D input image.
/// @param outputLabelImage The output label image. Its dimensions are forced to the same values as the input image.
/// @return Returns the outputLabelImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
expandLabelsOnBackground( std::shared_ptr< iolink::ImageView > inputLabelImage,
                          ExpandLabelsOnBackground::Neighborhood neighborhood,
                          std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
