/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Preserves a predefined number of objects according to a selected measurement.
class IMAGEDEV_CPP_API FilterByMeasurement final : public GenericAlgorithm
{
public:
    /// The filtering criterion.
    enum MeasurementFilterType
    {
    /// The algorithm preserves objects with highest values of the measurement.
        HIGHEST_VALUES = 0,
    /// The algorithm preserves objects with lowest values of the measurement.
        LOWEST_VALUES
    };

    // Command constructor.
    FilterByMeasurement();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image representing the objects to be filtered.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image representing the objects to be filtered.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputGrayImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the object input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the object input image will be used as the intensity input image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// The input grayscale image that contains the intensity information. It must have the same dimensions as the object input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the object input image will be used as the intensity input image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the measurement parameter.
    /// The filtering measurement.
    std::string measurement() const;
    /// Sets the measurement parameter.
    /// The filtering measurement.
    void setMeasurement( const std::string& measurement );

    /// Gets the measurementFilterType parameter.
    /// The filtering criterion.
    FilterByMeasurement::MeasurementFilterType measurementFilterType() const;
    /// Sets the measurementFilterType parameter.
    /// The filtering criterion.
    void setMeasurementFilterType( const FilterByMeasurement::MeasurementFilterType& measurementFilterType );

    /// Gets the objectCount parameter.
    /// The number of objects to be retained.
    int32_t objectCount() const;
    /// Sets the objectCount parameter.
    /// The number of objects to be retained.
    void setObjectCount( const int32_t& objectCount );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Preserves a predefined number of objects according to a selected measurement.
/// @param inputObjectImage The input binary or label image representing the objects to be filtered.
/// @param inputGrayImage The input grayscale image that contains the intensity information. It must have the same dimensions as the object input image. It is only used with measurements requiring an intensity image, and is ignored with other measurements. If it equals null, the object input image will be used as the intensity input image.
/// @param measurement The filtering measurement.
/// @param measurementFilterType The filtering criterion.
/// @param objectCount The number of objects to be retained.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
filterByMeasurement( std::shared_ptr< iolink::ImageView > inputObjectImage,
                     std::shared_ptr< iolink::ImageView > inputGrayImage,
                     const std::string& measurement,
                     FilterByMeasurement::MeasurementFilterType measurementFilterType,
                     int32_t objectCount,
                     std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
