/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Extracts a 2D section from a 3D volume.
class IMAGEDEV_CPP_API GetObliqueSliceFromVolume3d final : public GenericAlgorithm
{
public:
    /// The interpolation mode. Method used to calculate the intensity of each result voxel.
    enum InterpolationType
    {
    /// This mode gets the value of the nearest voxel.
        NEAREST_NEIGHBOR = 0,
    /// This mode gets the cubic interpolation from the nearest voxels.
        LINEAR
    };

    // Command constructor.
    GetObliqueSliceFromVolume3d();


    /// Gets the inputImage parameter.
    /// The input 3D image (the volume from which the slice is extracted).
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input 3D image (the volume from which the slice is extracted).
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the pointCoordinates parameter.
    /// Coordinates of a point of the 3D section.
    iolink::Vector3i32 pointCoordinates() const;
    /// Sets the pointCoordinates parameter.
    /// Coordinates of a point of the 3D section.
    void setPointCoordinates( const iolink::Vector3i32& pointCoordinates );

    /// Gets the thetaAngle parameter.
    /// The azimuthal angle in degrees (angle between the X axis and the projection of the normal on XY plane).
    double thetaAngle() const;
    /// Sets the thetaAngle parameter.
    /// The azimuthal angle in degrees (angle between the X axis and the projection of the normal on XY plane).
    void setThetaAngle( const double& thetaAngle );

    /// Gets the phiAngle parameter.
    /// The polar angle in degrees (angle between the normal and the Z axis).
    double phiAngle() const;
    /// Sets the phiAngle parameter.
    /// The polar angle in degrees (angle between the normal and the Z axis).
    void setPhiAngle( const double& phiAngle );

    /// Gets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each result voxel.
    GetObliqueSliceFromVolume3d::InterpolationType interpolationType() const;
    /// Sets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each result voxel.
    void setInterpolationType( const GetObliqueSliceFromVolume3d::InterpolationType& interpolationType );

    /// Gets the outputImage parameter.
    /// The output 2D image (the extracted slice).
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output 2D image (the extracted slice).
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Extracts a 2D section from a 3D volume.
/// @param inputImage The input 3D image (the volume from which the slice is extracted).
/// @param pointCoordinates Coordinates of a point of the 3D section.
/// @param thetaAngle The azimuthal angle in degrees (angle between the X axis and the projection of the normal on XY plane).
/// @param phiAngle The polar angle in degrees (angle between the normal and the Z axis).
/// @param interpolationType The interpolation mode. Method used to calculate the intensity of each result voxel.
/// @param outputImage The output 2D image (the extracted slice).
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
getObliqueSliceFromVolume3d( std::shared_ptr< iolink::ImageView > inputImage,
                             const iolink::Vector3i32& pointCoordinates,
                             double thetaAngle,
                             double phiAngle,
                             GetObliqueSliceFromVolume3d::InterpolationType interpolationType,
                             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
