/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes local gray level curvature in a two-dimensional image.
class IMAGEDEV_CPP_API ImageCurvature2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    ImageCurvature2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMaskImage parameter.
    /// The binary image designating the area to process. If it equals null, the algorithm is applied on the whole image. This image must have the same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary image designating the area to process. If it equals null, the algorithm is applied on the whole image. This image must have the same dimensions as the input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the standardDeviation parameter.
    /// The standard deviation for Gaussian filter, expressed in world coordinates of the input image.
    double standardDeviation() const;
    /// Sets the standardDeviation parameter.
    /// The standard deviation for Gaussian filter, expressed in world coordinates of the input image.
    void setStandardDeviation( const double& standardDeviation );

    /// Gets the outputRealImage parameter.
    /// The output image. Each pixel value represents the inverse of the local curvature radius in the world coordinates system. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputRealImage() const;
    /// Sets the outputRealImage parameter.
    /// The output image. Each pixel value represents the inverse of the local curvature radius in the world coordinates system. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputRealImage( std::shared_ptr< iolink::ImageView > outputRealImage );

    // Method to launch the command.
    void execute();

};

/// Computes local gray level curvature in a two-dimensional image.
/// @param inputImage The input image.
/// @param inputMaskImage The binary image designating the area to process. If it equals null, the algorithm is applied on the whole image. This image must have the same dimensions as the input image.
/// @param standardDeviation The standard deviation for Gaussian filter, expressed in world coordinates of the input image.
/// @param outputRealImage The output image. Each pixel value represents the inverse of the local curvature radius in the world coordinates system. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @return Returns the outputRealImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
imageCurvature2d( std::shared_ptr< iolink::ImageView > inputImage,
                  std::shared_ptr< iolink::ImageView > inputMaskImage,
                  double standardDeviation,
                  std::shared_ptr< iolink::ImageView > outputRealImage = nullptr );
} // namespace imagedev
